extends LevelWin
class_name LevelLose

func _set_ads_depend_ui():
	if not B4DFramework.is_ads_active:
		var reward_btn_ui : Control = get_node(
			"tint/main/double_reward/center/btn_rewarded_double/btn_lbl")
		var video_icon : Control = get_node(
			"tint/main/double_reward/center/btn_rewarded_double/video_icon")
		var lvl_retry_lbl : Control = get_node(
			"tint/main/double_reward/center/btn_rewarded_double/lvl_action_lbl")
		var footer_retry_next : Control = get_node("tint/main/next_retry/hbox")
		
		## Hide show ads depend UI
		reward_btn_ui.visible = false
		video_icon.visible = false
		footer_retry_next.visible = false
		
		lvl_retry_lbl.visible = true

func _show_ui() -> void:
	UserData.update_score(B4DFramework.get_coins_count() + int(_earnings.text),
	B4DFramework.get_level())
	
	_animation.stop(true)
	_animation.play("level_lose_appear")
	_animation.queue("btn_x2reward_bounce")


func _on_retry_pressed() -> void:
	Sounds.play_tap_sound()
	if B4DFramework.b4d_ads.get_is_interstitial_loaded():
		B4DFramework.b4d_ads.show_interstitial()
	else:
		_interstitial_closed()
	

func _change_title():
	pass

func _on_btn_rewarded_pressed() -> void:
	._on_btn_rewarded_pressed()


func _reward(currency , amount) -> void:
	._reward(currency , amount)


func _interstitial_closed() -> void:
	._interstitial_closed()

